/*
 * Decompiled with CFR 0.152.
 */
package jace;

import jace.Emulator;
import jace.apple2e.MOS65C02;
import jace.core.CPU;
import jace.core.Computer;
import jace.core.Debugger;
import jace.core.RAM;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import jace.ui.MainFrame;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EmulatorUILogic {
    static Debugger debugger = new Debugger(){

        @Override
        public void updateStatus() {
            EmulatorUILogic.enableDebug(true);
            MOS65C02 cpu = (MOS65C02)Computer.getComputer().getCpu();
            EmulatorUILogic.updateCPURegisters(cpu);
        }
    };
    public static List<RAMListener> watches = new ArrayList<RAMListener>();

    public static void updateCPURegisters(MOS65C02 cpu) {
        MainFrame main = MainFrame.instance;
        main.valueA.setText(Integer.toHexString(cpu.A));
        main.valueX.setText(Integer.toHexString(cpu.X));
        main.valueY.setText(Integer.toHexString(cpu.Y));
        main.valuePC.setText(Integer.toHexString(cpu.getProgramCounter()));
        main.valueSP.setText(Integer.toHexString(cpu.getSTACK()));
        main.valuePC2.setText(cpu.getState());
        main.valueINST.setText(cpu.disassemble());
    }

    public static void enableDebug(boolean b) {
        MainFrame m = MainFrame.instance;
        debugger.setActive(b);
        m.enableDebug.setSelected(b);
        m.debugger.setBackground(b ? Color.RED : Color.BLUE);
        if (!b) {
            EmulatorUILogic.stepForward();
        }
    }

    public static void enableTrace(boolean b) {
        MainFrame m = MainFrame.instance;
        Computer.getComputer().getCpu().setTraceEnabled(b);
    }

    public static void stepForward() {
        Computer.getComputer().getCpu().setHalt(false);
    }

    static void registerDebugger() {
        Computer.getComputer().getCpu().setDebug(debugger);
    }

    public static Integer getValidAddress(String s) {
        try {
            int addr = Integer.parseInt(s.toUpperCase(), 16);
            if (addr >= 0 && addr < 65536) {
                return addr;
            }
            return null;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static void updateWatchList() {
        MainFrame main = MainFrame.instance;
        EmulatorUILogic.haltCPU();
        for (RAMListener oldWatch : watches) {
            Computer.getComputer().getMemory().removeListener(oldWatch);
        }
        if (main == null) {
            return;
        }
        EmulatorUILogic.addWatch(main.textW1, main.valueW1);
        EmulatorUILogic.addWatch(main.textW2, main.valueW2);
        EmulatorUILogic.addWatch(main.textW3, main.valueW3);
        EmulatorUILogic.addWatch(main.textW4, main.valueW4);
        EmulatorUILogic.resumeCPU();
    }

    private static void resumeCPU() {
        if (!debugger.isActive()) {
            Computer.getComputer().getCpu().setHalt(false);
        }
    }

    private static void haltCPU() {
        Computer.getComputer().getCpu().setHalt(true);
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    private static void addWatch(JTextField watch, final JLabel watchValue) {
        final Integer address = EmulatorUILogic.getValidAddress(watch.getText());
        if (address != null) {
            RAMListener newListener = new RAMListener(RAMEvent.TYPE.WRITE, RAMEvent.SCOPE.ADDRESS, RAMEvent.VALUE.ANY){

                @Override
                protected void doConfig() {
                    this.setScopeStart(address);
                }

                @Override
                protected void doEvent(RAMEvent e) {
                    watchValue.setText(Integer.toHexString(e.getNewValue() & 0xFF));
                }
            };
            Computer.getComputer().getMemory().addListener(newListener);
            watches.add(newListener);
            byte b = Computer.getComputer().getMemory().read(address, false);
            watchValue.setText(Integer.toString(b & 0xFF, 16));
        } else {
            watchValue.setText("00");
        }
    }

    public static void updateBreakpointList() {
        MainFrame main = MainFrame.instance;
        EmulatorUILogic.haltCPU();
        debugger.getBreakpoints().clear();
        if (main == null) {
            return;
        }
        Integer address = EmulatorUILogic.getValidAddress(main.textBP1.getText());
        if (address != null) {
            debugger.getBreakpoints().add(address);
        }
        if ((address = EmulatorUILogic.getValidAddress(main.textBP2.getText())) != null) {
            debugger.getBreakpoints().add(address);
        }
        if ((address = EmulatorUILogic.getValidAddress(main.textBP3.getText())) != null) {
            debugger.getBreakpoints().add(address);
        }
        if ((address = EmulatorUILogic.getValidAddress(main.textBP4.getText())) != null) {
            debugger.getBreakpoints().add(address);
        }
        debugger.updateBreakpoints();
        EmulatorUILogic.resumeCPU();
    }

    public static void runFile() {
        Computer.getComputer().getCpu().setHalt(true);
        JFileChooser select = new JFileChooser();
        select.showDialog(MainFrame.instance, "Execute binary file");
        File binary = select.getSelectedFile();
        if (binary == null) {
            Computer.getComputer().getCpu().setHalt(false);
            return;
        }
        EmulatorUILogic.runFile(binary);
    }

    public static void runFile(File binary) {
        String fileName = binary.getName().toLowerCase();
        try {
            if (fileName.contains("#06")) {
                String addressStr = fileName.substring(fileName.length() - 4);
                int address = Integer.parseInt(addressStr, 16);
                EmulatorUILogic.brun(binary, address);
            } else if (fileName.contains("#fc")) {
                System.out.println("BASIC not supported yet");
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Computer.getComputer().getCpu().setHalt(false);
    }

    public static void brun(File binary, int address) throws FileNotFoundException, IOException {
        boolean halted = Computer.getComputer().getCpu().isHalt();
        Computer.getComputer().getCpu().setHalt(true);
        FileInputStream in = new FileInputStream(binary);
        byte[] data = new byte[in.available()];
        in.read(data);
        RAM ram = Computer.getComputer().getMemory();
        for (int i = 0; i < data.length; ++i) {
            ram.write(address + i, data[i], false);
        }
        CPU cpu = Computer.getComputer().getCpu();
        Computer.getComputer().getCpu().setProgramCounter(halted ? address : address - 1, true);
        Computer.getComputer().getCpu().setHalt(false);
    }

    public static void scaleIntegerRatio() {
        int vscale;
        int ww = MainFrame.instance.getWidth();
        int wh = MainFrame.instance.getHeight();
        int w = MainFrame.instance.getContentPane().getWidth();
        int h = MainFrame.instance.getContentPane().getHeight();
        int bw = ww - w;
        int bh = wh - h;
        double dhscale = (double)w / 560.0;
        double dvscale = (double)h / 384.0;
        int hscale = (int)Math.round(dhscale);
        int scale = Math.min(hscale, vscale = (int)Math.round(dvscale));
        if (scale < 1) {
            scale = 1;
        }
        Rectangle b = MainFrame.instance.getBounds();
        b.setSize(bw + 560 * scale, bh + 384 * scale);
        MainFrame.instance.setBounds(b);
        Emulator.resizeVideo();
    }
}

